import { jsx, jsxs } from "react/jsx-runtime";
import { useEditor } from "@tldraw/editor";
import * as React from "react";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { TldrawUiButton } from "../primitives/Button/TldrawUiButton.mjs";
import { TldrawUiButtonIcon } from "../primitives/Button/TldrawUiButtonIcon.mjs";
import { TldrawUiButtonLabel } from "../primitives/Button/TldrawUiButtonLabel.mjs";
import {
  TldrawUiDropdownMenuContent,
  TldrawUiDropdownMenuItem,
  TldrawUiDropdownMenuRoot,
  TldrawUiDropdownMenuTrigger
} from "../primitives/TldrawUiDropdownMenu.mjs";
function _DropdownPicker({
  id,
  label,
  uiType,
  style,
  items,
  type,
  value,
  onValueChange
}) {
  const msg = useTranslation();
  const editor = useEditor();
  const icon = React.useMemo(
    () => items.find((item) => value.type === "shared" && item.value === value.value)?.icon,
    [items, value]
  );
  const titleStr = value.type === "mixed" ? msg("style-panel.mixed") : msg(`${uiType}-style.${value.value}`);
  const labelStr = label ? msg(label) : "";
  return /* @__PURE__ */ jsxs(TldrawUiDropdownMenuRoot, { id: `style panel ${id}`, children: [
    /* @__PURE__ */ jsx(TldrawUiDropdownMenuTrigger, { children: /* @__PURE__ */ jsxs(TldrawUiButton, { type, "data-testid": `style.${uiType}`, title: titleStr, children: [
      /* @__PURE__ */ jsx(TldrawUiButtonLabel, { children: labelStr }),
      /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: icon ?? "mixed" })
    ] }) }),
    /* @__PURE__ */ jsx(TldrawUiDropdownMenuContent, { side: "left", align: "center", alignOffset: 0, children: /* @__PURE__ */ jsx("div", { className: "tlui-buttons__grid", children: items.map((item) => {
      return /* @__PURE__ */ jsx(TldrawUiDropdownMenuItem, { children: /* @__PURE__ */ jsx(
        TldrawUiButton,
        {
          type: "icon",
          "data-testid": `style.${uiType}.${item.value}`,
          title: msg(`${uiType}-style.${item.value}`),
          onClick: () => {
            editor.mark("select style dropdown item");
            onValueChange(style, item.value);
          },
          children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: item.icon })
        }
      ) }, item.value);
    }) }) })
  ] });
}
const DropdownPicker = React.memo(_DropdownPicker);
export {
  DropdownPicker
};
//# sourceMappingURL=DropdownPicker.mjs.map
